unit uGetNum;

interface

Const
  MaxNum = 5; MaxStr = 5;
  Wortbestandteil = ['A'..'Z','a'..'z','0'..'9', '_', '-'];
  cStr = '$'; cNum = '#'; cOwn = '*';

Type TNumTyp = (ntUndefinded, ntOriginal, ntTrunc, ntLen);

Type
  TNumParameter = Record
     Anz, AnzNum, AnzStr, Typ: Integer;
     Nums: Array[1..MaxNum] of Double;
     Strs: Array[1..MaxStr] of String;
     Args: String;
  end;
  TFehlerProc = Procedure (Const Fehler, Restzeile: String) of Object;
  TBoolNumFunc = Function (Var Pars: TNumParameter): Double of Object;
  TGetStrFunc = Function (Var s, Inhalt: String): boolean;
  TGetVarValue = Function (Const VarName: String): Double of Object;

Procedure Init_GetNum (GS: TGetStrFunc; GV: TGetVarValue; F: TFehlerProc);
Procedure Register_NumFunktion (Const Bez: String; Const Par: String;
            Pr: TBoolNumFunc; Const AktTyp: Integer);
Procedure Unregister_NumFunktion (Const Bez: String);

Function GetNumber (Var Zeile: String; Var Ergebnis: Double): boolean;

{ ---------------------------------------------------------------------- }

implementation

Uses SysUtils, Classes, Settings, uTransla;

Var
   Fehler: TFehlerproc;
   GetString: TGetStrFunc;
   GetVarValue: TGetVarValue;
   lFunctions: TList;

Type
   PFunctiondef = ^TFunctiondef;
   TFunctiondef = Record
      Bezeichnung, Parameter: String; Typ: Integer;
      AllowStringPar: Boolean;
      Run: TBoolNumFunc;
   end;

Function GetNumber (Var Zeile: String; Var Ergebnis: Double): boolean;
Type TModus = (kLeer, kRech, kVorz, kVK, kNK, kNNK, kFunktion, kVariable, kFertig);
     TRechnung = (kAdd, kDel, kMul, kDiv, kPower, kSchluss);
     TPrio = (PZero, PStrich, PPunkt, PPower);
Const Prio: Array[TRechnung] of TPrio =
                 (PStrich, PStrich, PPunkt, PPunkt, PPower, PStrich);
      NK_allowed = true;
Var R_Typ: Array[TPrio] of TRechnung;
    R_Used: Array[TPrio] of boolean;
    R_Erg: Array[TPrio] of Double;
    R_Akt: Array[TPrio] of Double;
    Vorz, Fakultaet: Integer; Akt, Teiler: Double;
    Rechnung: TRechnung; M: TModus;

    Procedure Ups;
    begin
       Fehler (TrF('InterpreteNumeric.Error',
          'Fehler in Formel, ab "%s" keine sinnvolle Interpretation mglich', [Zeile]), Zeile);
    end;

    Procedure Rechne (Const P: TPrio);
    begin
        If R_Used[P] then begin
           {Case R_Typ[P] of
             kAdd: Global.Showmessage('Rechne '+FloatToStr(R_Erg[P])+' + '+FloatToStr(R_Akt[P]));
             kDel: Global.Showmessage('Rechne '+FloatToStr(R_Erg[P])+' - '+FloatToStr(R_Akt[P]));
             kMul: Global.Showmessage('Rechne '+FloatToStr(R_Erg[P])+' * '+FloatToStr(R_Akt[P]));
             kDiv: Global.Showmessage('Rechne '+FloatToStr(R_Erg[P])+' / '+FloatToStr(R_Akt[P]));
           end;{}
           Case R_Typ[P] of
             kAdd: R_Erg[P] := R_Erg[P] + R_Akt[P];
             kDel: R_Erg[P] := R_Erg[P] - R_Akt[P];
             kMul: R_Erg[P] := R_Erg[P] * R_Akt[P];
             kDiv: R_Erg[P] := R_Erg[P] / R_Akt[P];
             kPower: R_Erg[P] := Exp( ln (R_Erg[P]) * R_Akt[P] )
           end
        end else begin
           R_Used[p] := true;
           R_Erg[P] := R_Akt[P]
        end;
        Ergebnis := R_Erg[P]
    end;

    Procedure AddZahl (Const FolgeRechnung: TRechnung);
    Var AktPrio, NextPrio: TPrio; i: Integer; x: Double; p: TPrio;
    begin
       { Vorzeichen und Teiler integrieren }
       If Akt > 0 then Akt := Vorz * Akt;
       If Teiler > 0 then Akt := Akt / Teiler;
       While Fakultaet > 0 do begin
          x := 1; For i:=2 to Trunc(Akt) do x := x * i;
          Akt := x; Dec(Fakultaet)
       end;
       { Hherwertige Restrechnungen durchfhren }
       AktPrio := Prio[Rechnung]; NextPrio := Prio[FolgeRechnung];
       If AktPrio = NextPrio then begin
          R_Akt[AktPrio] := Akt;  R_Typ[AktPrio] := Rechnung; Rechne (AktPrio)
       end else If AktPrio < NextPrio then begin { = Hhere Ebene folgt }
          R_Typ[AktPrio] := Rechnung;
          R_Akt[NextPrio] := Akt;
          R_Typ[NextPrio] := FolgeRechnung;
          Rechne (NextPrio);
          For p := Succ(AktPrio) to Pred(NextPrio) do R_used[p] := false;
       end else begin { = Niedrigere Ebene folgt }
          R_Akt[AktPrio] := Akt;
          R_Typ[AktPrio] := Rechnung;
          Rechne (AktPrio);
          For p := Aktprio downto Succ(NextPrio) do begin
             If R_used[p] then begin
                R_Used[p] := false;
                R_Akt[Pred(P)] := R_Erg[P];
                Rechne (Pred(P))
             end else begin
                R_Erg[Pred(P)] := R_Erg[P]
             end;
          end;
          Ergebnis := R_Erg[NextPrio]
       end;
       Teiler := 1; Vorz := 1; Fakultaet := 0;
       M:=kRech; Rechnung := FolgeRechnung
    end;

    Procedure Klammerausdruck;
    begin
       Zeile := Copy(Zeile, 2, Length(Zeile)-1); { Um Klammer krzen }
       GetNumber (Zeile, Akt); { Zahl einlesen }
       M := kNNK
    end;

    Function Rechenfunktion (Const FName: String; Const HatPars, muss: boolean): boolean;
    Var Weitere: boolean;

       Function GetNext: Double;
       begin
          Zeile := Copy(Zeile, 2, Length(Zeile)-1);
          GetNumber(Zeile, Result);
          Weitere := Zeile[1] = ','; M := kNNK
       end;
       Function GetStr: String;
       begin
          Zeile := Copy(Zeile, 2, Length(Zeile)-1);
          If Not GetString(Zeile, Result) then
             Fehler(TrF('InterpreteString.Error',
                'Kein gltiger String-Ausdruck: "%s"', [Zeile]), '');
          Weitere := Zeile[1] = ','; M := kNNK
       end;

    Var F: TFunctiondef; Pars: TNumParameter; i, j: Integer;
    begin
       Result := false;
       For i:=0 to lFunctions.Count-1 do begin
          F := PFunctiondef(lFunctions[i])^;
          If HatPars <> (F.Parameter > '') then continue;
          If LowerCase(FName) = LowerCase(F.Bezeichnung) then begin
             Pars.AnzNum := 0; Pars.AnzStr := 0;
             Pars.Typ := F.Typ; Pars.Args := '';
             If F.Parameter > '' then begin
                If F.Parameter = cOwn then Pars.Args := Copy(Zeile, 2, Length(Zeile)-1)
                else begin
                   For j:=1 to Length(F.Parameter) do begin
                      Case F.Parameter[j] of
                         cStr: begin Inc(Pars.AnzStr); Pars.Strs[Pars.AnzStr] := GetStr end;
                         cNum: begin Inc(Pars.AnzNum); Pars.Nums[Pars.AnzNum] := GetNext end;
                      end;
                      If (Not Weitere) and (j < Length(F.Parameter))
                            then Fehler(TrF('FunctionToManyParameters.Error',
                                   'Syntaxfehler: Die Funktion "%s" erwartet %s und nicht nur %s Parameter',
                                   [F.Bezeichnung, Inttostr(Length(F.Parameter)), IntToStr(j)]),
                                   Zeile)
                   end;
                   If Weitere then Fehler(TrF('FunctionNotEnoughParameters.Error',
                        'Syntaxfehler: Die Funktion "%s" braucht nur %s Parameter',
                        [F.Bezeichnung, Inttostr(Length(F.Parameter))]),
                        Zeile)
                end
             end;
             Pars.Anz := Pars.AnzNum + Pars.AnzStr;
             Akt := F.Run (Pars);
             M := kNNK;
             If F.Parameter = cOwn then Zeile := Pars.Args;
             Result := true;
             exit
          end
       end;
       If muss then begin
          Fehler(TrF('UnknownNumericFunction.Error',
              'Syntaxfehler: Unbekannte numerische Funktion "%s"', [FName]), Zeile)
       end
    end;

// Function GetNumber (Var Zeile: String; Var Ergebnis: Double): boolean;
Var FName: String; c: Char; p: TPrio; b, DeleteChar: boolean; i: Integer;
begin
   Ergebnis := 0.0; Result := false;
   If Not Assigned(Fehler) then exit;
   If Not Assigned(GetString) then exit;
   M := kLeer; Vorz := 1; Teiler := 1; Rechnung := kAdd; Fakultaet := 0;
   For p := Low(TPrio) to High(TPrio) do R_used[p] := false;
   While (Zeile > '') and (M<>kFertig) do begin
      c := Upcase(Zeile[1]);
      DeleteChar := true;
      If Not (M IN [kFunktion, kVariable]) then begin
         If Not (c IN ['A'..'Z','.', '0'..'9','+','-','*','/','^','(',' ','!', '%'])
            or
            ((c IN ['A'..'Z','0'..'9']) and (M = kNNK))
         then
            M := kFertig
      end;

      Case M of
         kLeer, kRech: { Anfang bzw. Rechenzeichen ist gemerkt (=>Rechnung) }
            Case c of
               ' ': ;
               '(': Klammerausdruck;
               '+', '-': begin M := kVorz; If c='-' then Vorz := -1 end;
               '*', '/', '^': Ups;
               '0'..'9': begin M := kVK; Akt := StrToInt(c) end;
               'A'..'Z': begin M := kFunktion; FName := c end;
               '%': begin M := kVariable; FName := '' end;
               else Ups
            end;
         kVorz: { Vorzeichen ist gesetzt (Vorz=+/-1) }
            Case c of
               ' ': ;
               '(': Klammerausdruck;
               '+', '-', '*', '/', '^': Ups;
               '0'..'9': begin M := kVK; Akt := StrToInt(c) end;
               'A'..'Z': begin M := kFunktion; FName := c end;
               '%': begin M := kVariable; FName := '' end;
               else Ups
            end;
         kVK, kNK, kNNK: { Vor-/Nachkommastellen werden eingelesen bzw. Zahl komplett }
            Case c of
               ' ': If M < kNNK then M := kNNK;
               '+': AddZahl (kAdd);
               '-': AddZahl (kDel);
               '*': AddZahl (kMul);
               '/': AddZahl (kDiv);
               '^': AddZahl (kPower);
               '!': If (M=kNK) or (Frac(Akt)<>0) or (Akt<0) then
                        Fehler (TrL('Function"!"NeedsPositiveInteger',
                           'Fakultt ist nur bei ganzen und positiven Zahlen zulssig'), Zeile)
                    else begin M := kNNK; Inc(Fakultaet) end;
               '0'..'9':
                  If M = kNNK then Ups
                  else begin
                     Akt := Akt * 10 + StrToInt(c);
                     If M = kNK then Teiler := Teiler * 10
                  end;
               '.': If M=kNK then Ups else M := kNK
               else Ups
            end;
         kFunktion:
            begin
               b := true;
               If c = ' ' then begin
                  For i := 2 to Length(Zeile) do begin
                     If Zeile[i] <> ' ' then begin
                        If Zeile[i] = '(' then begin
                           Delete (Zeile, 1, i-1);
                           c := Zeile[1]
                        end;
                        break
                     end
                  end
               end;
               Case c of
                  'A'..'Z': FName := FName + c;
                  '(': b := Rechenfunktion(FName, true, false);
                  ' ': b := Rechenfunktion(FName, false, false);
                  else begin
                     DeleteChar := false;
                     b := Rechenfunktion(FName, false, false)
                  end;
               end;
               If Not b then begin
                  Zeile := FName + Zeile; Result := false; exit
               end
            end;
         kVariable:
            begin
               If c IN Variablenzeichen then
                  FName := FName + c
               else If c = '%' then begin
                  If Assigned(GetVarValue)
                     then Akt := GetVarValue(FName)
                     else Akt := 0;
                  M := kNNK
               end else begin
                  Fehler (TrF('IllegalCharinVarName',
                       'Unzulssiges Zeichen in Variablennamen: "%s"', [c]), '')
               end
            end;
      end;
      If (M <> kFertig) and DeleteChar then begin
         Delete(Zeile, 1, 1); Result := true
      end;
      If (Zeile = '') and (M = kFunktion) then Rechenfunktion(FName, false, true)
   end;
   if Result then AddZahl (kSchluss)
end;

Procedure Init_GetNum (GS: TGetStrFunc; GV: TGetVarValue; F: TFehlerProc);
begin
  GetString := GS;
  GetVarValue := GV;
  Fehler := F
end;

Type TFunc = (fTrunc, fRandom, fAbs, fSQRT, fMax, fMin, fSGN, fVal, fCount,
              fPos, fLength, fOrd, fpi);

     TDummy = Class
        public
           Function InternalFuncs (Var Pars: TNumParameter): Double;
     end;
     
Function TDummy.InternalFuncs (Var Pars: TNumParameter): Double;
Var s: String; i: Integer; x: Double;
begin
   Result := 0;
   With Pars do Case TFunc(Typ) of
      fTrunc: Result := Trunc(Nums[1]);
      fRandom: Result := Random(Trunc(Nums[1]));
      fAbs: Result := Abs(Nums[1]);
      fSQRT: Result := SQRT(Nums[1]);
      fMax: begin
         GetNumber(Args, Result);
         While Copy(Args, 1, 1)=',' do begin
            Args := Copy(Args, 2, Length(Args)-1);
            GetNumber(Args, x);
            If x > Result then Result := x
         end
      end;
      fMin: begin
         GetNumber(Args, Result);
         While Copy(Args, 1, 1)=',' do begin
            Args := Copy(Args, 2, Length(Args)-1);
            GetNumber(Args, x);
            If x < Result then Result := x
         end
      end;
      fSGN: If Nums[1]>0 then Result:=1 else If Nums[1]<0 then Result :=-1 else Result := 0;
      fVal: begin
         s := Strs[1];
         If (Not GetNumber(s, Result)) or (s>'') then
            Fehler(TrF('InvalidNumericExpression',
               'Ungltiger numerischer Ausdruck "%s"', [Strs[1]]) , Strs[1])
      end;
      fCount: For i:=1 to Length(Strs[2])-Length(Strs[1])+1 do
                 If Copy(Strs[2], i, Length(Strs[1]))=Strs[1] then Result := Result + 1;
      fPos: Result := Pos(Strs[1], Strs[2]);
      fLength: Result := Length(Strs[1]);
      fOrd: If Length(Strs[1]) > 0 then Result := Ord(Strs[1][1]) else Result := 0;
      fPI: Result := 3.14159265358979;
   end
end;

Var Dummy: TDummy;

Procedure Init;
begin
   If Not Assigned(lFunctions) then With Dummy do begin
     lFunctions := TList.Create;
     Register_NumFunktion ('Trunc', cNum, InternalFuncs, Ord(fTrunc));
     Register_NumFunktion ('Random', cNum, InternalFuncs, Ord(fRandom));
     Register_NumFunktion ('Abs', cNum, InternalFuncs, Ord(fAbs));
     Register_NumFunktion ('Sqrt', cNum, InternalFuncs, Ord(fSQRT));
     Register_NumFunktion ('Max', cOwn, InternalFuncs, Ord(fMax));
     Register_NumFunktion ('Min', cOwn, InternalFuncs, Ord(fMin));
     Register_NumFunktion ('SGN', cNum, InternalFuncs, Ord(fSGN));
     Register_NumFunktion ('Val', cStr, InternalFuncs, Ord(fVal));
     Register_NumFunktion ('Count', cStr+cStr, InternalFuncs, Ord(fCount));
     Register_NumFunktion ('Pos', cStr+cStr, InternalFuncs, Ord(fPos));
     Register_NumFunktion ('Length', cStr, InternalFuncs, Ord(fLength));
     Register_NumFunktion ('Len', cStr, InternalFuncs, Ord(fLength));
     Register_NumFunktion ('Ord', cStr, InternalFuncs, Ord(fOrd));
     Register_NumFunktion ('pi', '', InternalFuncs, Ord(fpi));
   end
end;

Procedure Register_NumFunktion (Const Bez: String; Const Par: String;
            Pr: TBoolNumFunc; Const AktTyp: Integer);
Var P: PFunctiondef;
begin
   Init;
   New (P);
   With P^ do begin
      Bezeichnung := Bez;
      Parameter := Par;
      Typ := AktTyp;
      Run := Pr
   end;
   lFunctions.Add (P)
end;

Procedure Unregister_NumFunktion (Const Bez: String);
Var i: Integer;
begin
   With lFunctions do begin
      For i := Count-1 downto 0 do begin
         With PFunctiondef(Items[i])^ do begin
            If Bezeichnung = Bez then begin
               lFunctions.Delete(i); Exit
            end
         end
      end
   end
end;

initialization
   Randomize;
   Dummy := TDummy.Create;
   Init
finalization
   With LFunctions do While Count > 0 do begin
      Dispose (PFunctiondef(Items[0])); Delete(0)
   end;
   lFunctions.free;
   Dummy.free
end.
