unit uGetStr;

interface

Type
  TSt = (stChr, stLower, stUpper, stEscRegExp, stToStr, stToIStr, stExtract, stReplace,
         stCutLeft, stCutRight, stLeft, stRight, stCopy, stTab, stCRLF, stSigDel,
         stLTrim, stRTrim, stTrim, stWordWrap, stFillChar, stReadIni,
         stDateTime, stDosToWin, stWinToDos);

Const
  MaxNum = 5; MaxStr = 5;
  Wortbestandteil = ['A'..'Z','a'..'z','0'..'9', '_', '-'];
  cStr = '$'; cNum = '#'; cOwn = '*';

Type
  TStrParameter = Record
     Anz, AnzNum, AnzStr, Typ: Integer;
     Nums: Array[1..MaxNum] of Double;
     Strs: Array[1..MaxStr] of String;
     Rest: String;
  end;
  TGetVarNameProc = Function (Var Gesamt, VarName: String): boolean of Object;
  TFehlerProc = Procedure (Const Fehler, Restzeile: String) of Object;
  TBoolStrFunc = Function (Var Pars: TStrParameter): String of Object;
  TStrFunc = Function (Const s:String): String of Object;

Function ToStr(Const D: Double): String;
Function ToNum(Const s: String): Double;

Procedure Init_GetString (VN: TGetVarNameProc; VI: TStrFunc; F: TFehlerProc);
Procedure Register_StrFunktion (Const Bez: String; Const Par: String;
     Const AllowSingleStr: Boolean; Pr: TBoolStrFunc; Const AktTyp: Integer);
Procedure Unregister_StrFunktion (Const Bez: String);

Function GetString(Var s, Inhalt: String): boolean;
Function SucheUndKuerze(Const Anfang: String; Var s: String): boolean;
Function Klammerung(Var s, Inhalt: String; Const Entfernen: boolean): boolean;
Function ExtractRegExp (Const Reg, Vergl: String): String;
Function TestRegExp (Const Reg, Vergl: String): boolean;
Function WordWrap (Const Org, Einrueckung: String; Const Breite: Integer): String;
Function RTrim(Const s: String): String;
Function LTrim(Const s: String): String;

Function FormatDateTime5 (const Format: string; DateTime: TDateTime): String;

{ ---------------------------------------------------------------------- }

implementation

Uses Classes, SysUtils, uGetNum, UPerlRe, IniFiles, Windows, uTransla;

Var
   GetVarName: TGetVarNameProc;
   GetVarValue: TStrFunc;
   Fehler: TFehlerproc;
   lFunctions: TList;

Type
   PFunctiondef = ^TFunctiondef;
   TFunctiondef = Record
      Bezeichnung, Parameter: String; Typ: Integer;
      AllowStringPar: Boolean;
      Run: TBoolStrFunc;
   end;
   TDummy = Class
     public
       Function InternalFuncs (Var Pars: TStrParameter): String;
   end;

Function ExtractRegExp (Const Reg, Vergl: String): String;
Var sl: TStringlist; s: String; ls, lv: Integer;
begin
   sl := TStringlist.Create;
   With TPerlRe.Create (true, 0 {PCRE_MULTILINE}) do try
      Split (Reg, Vergl, sl, false);
      If sl.Count=1 then begin
         s := sl[0]; ls := Length(s); lv := Length(Vergl);
         If s = Vergl then Result := ''
         else If s = '' then Result := Vergl
         else If Copy(Vergl, 1, ls)=s then Result := Copy(Vergl, ls+1, lv-ls)
         else If Copy(Vergl, lv-ls+1, ls)=s then Result := Copy(Vergl, 1, lv-ls)
         else Result := '';
      end else If sl.Count = 2 then
         Result := Copy(Vergl, Length(sl[0])+1, Length(Vergl)-Length(sl[0])-Length(sl[1]))
      else If sl.Count > 2 then begin
         Result := Copy(Vergl, Length(sl[0])+1, Length(Vergl));
         Result := Copy(Result, 1, Pos(sl[1], Result)-1)
      end
   finally free; sl.free end
end;

Function TestRegExp (Const Reg, Vergl: String): boolean;
begin
   With TPerlRe.Create (true, 0) do try
      Result := MatchRS (Reg, Vergl)
   finally free end
end;

Function ReplaceString (Const Inhalt, Reg, Ersatz: String): String;
Var hl: TStringlist; PerlRe: TPerlRe; ls, lv, j: Integer;
    s, Ersatz2: String; 
begin
   Result := Inhalt;
   If Inhalt = '' then exit;
   hl := TStringlist.Create;
   PerlRe := TPerlRe.Create(true, 0);
   Ersatz2 := Ersatz;
   try
      hl.Clear; PerlRe.Split (Reg, Inhalt, hl, false); 
      s := hl[0];
      If hl.Count>1 then begin
         Result := s; For j := 1 to hl.Count-1 do Result := Result + Ersatz2 + hl[j];
         j := hl.Count-1; ls := Length(hl[j]); lv := Length(Inhalt);
         If Copy(Inhalt, lv-ls+1, ls) <> hl[j] then Result := Result + Ersatz2;
      end else If s <> Inhalt then begin
         ls := Length(s); lv := Length(Inhalt);
         If s = '' then Result := Ersatz2
         else If Copy(Inhalt, 1, ls)=s then Result := s + Ersatz2
         else If Copy(Inhalt, lv-ls+1, ls)=s then Result := Ersatz2 + s;
      end
   finally
      hl.free; PerlRe.free
   end
end;

Function Klammerung(Var s, Inhalt: String; Const Entfernen: boolean): boolean;
Var i, L: Integer; c: Char;
begin
   s := Trim(s);
   If (s>'') and (s[1]='(') then begin
      i := 1; L := 1;
      While (L>0) and (i<Length(s)) do begin
         Inc(i); c := s[i];
         Case s[i] of
            '(': Inc(L);
            ')': Dec(L);
            '"','''': Repeat
                         Inc(i)
                      Until (i>Length(s)) or (s[i]=c)
         end
      end;
      Result := L=0;
      If Result then begin
         Inhalt := Trim(Copy(s, 2, i-2));
         If Entfernen then s := Trim(Copy(s, i+1, Length(s)-i))
      end
   end else Result := false;
end;

Function SucheUndKuerze(Const Anfang: String; Var s: String): boolean;
Var Sonderzeichen: boolean; I, l: Integer;
begin
   Sonderzeichen:=true; L := Length(Anfang);
   For i:=1 to L do If Upcase(Anfang[i]) IN Wortbestandteil then begin
      Sonderzeichen := false; break
   end;
   Result := (LowerCase(Copy(s,1,L)) = LowerCase(Anfang))
             and ((Length(s) = L) or Sonderzeichen or Not (Upcase(s[L+1]) IN['A'..'Z']));
   If Result
      then s := Trim(Copy(s, L+1, Length(s)-L))
end;


Procedure Init_GetString (VN: TGetVarNameProc; VI: TStrFunc; F: TFehlerProc);
begin
  GetVarName := VN;
  GetVarValue := VI;
  Fehler := F
end;

Function GetString(Var s, Inhalt: String): boolean;
Var s2, s3: String;
    ok, Fertig, Original: boolean;
    p, i, j: Integer;
    Pars: TStrParameter;
    F: TFunctionDef;
    x: Double;
begin
   Result := false;
   If Not Assigned(Fehler) then exit;
   While (s > '') and (s[1]=' ') do Delete(s, 1, 1);

   Original := true; Fertig := false;
   If Assigned(GetVarName) and GetVarName(s, s2) then begin
      Inhalt := GetVarValue(s2); Result := true;
      Fertig := true
   end else begin
      For i:=0 to lFunctions.Count-1 do begin
         F := PFunctiondef(lFunctions[i])^;
         If SucheUndKuerze(F.Bezeichnung, s) then begin
            Pars.AnzNum := 0; Pars.AnzStr := 0;
            Pars.Typ := F.Typ;
            If F.Parameter <> cOwn then begin
               If F.Parameter > '' then begin
                  If Klammerung(s, s2, true) then begin
                     For j:=1 to Length(F.Parameter) do begin
                        Case F.Parameter[j] of
                           cStr: If GetString (s2, s3) then begin
                                    Inc(Pars.AnzStr); Pars.Strs[Pars.AnzStr] := s3
                                 end else If F.AllowStringPar then begin
                                    Inc(Pars.AnzStr); Pars.Strs[Pars.AnzStr] := s2; s2 := ''
                                 end else
                                    Fehler(TrF('FunctionNeedsStringAsXPar',
                                       'Syntaxfehler: Die Funktion "%s" erwartet als %s. Parameter einen String',
                                       [F.Bezeichnung, IntToStr(j)]), s2);
                           cNum: If GetNumber (s2, x) then begin
                                    Inc(Pars.AnzNum); Pars.Nums[Pars.AnzNum] := x
                                 end else
                                    Fehler(TrF('FunctionNeedsNumAsXPar',
                                       'Syntaxfehler: Die Funktion "%s" erwartet als %s. Parameter einen numerischen Ausdruck',
                                       [F.Bezeichnung, IntToStr(j)]), s2);
                        end;
                        If (j < Length(F.Parameter)) and Not SucheUndKuerze(',', s2)
                           then Fehler(TrF('FunctionNeedsXAndNotOnlyYPars',
                              'Syntaxfehler: Die Funktion "%s" erwartet %s und nicht nur %s Parameter',
                              [F.Bezeichnung, Inttostr(Length(F.Parameter)), IntToStr(j)]),
                              s)
                     end;
                     If s2 > '' then Fehler(TrF('FunctionNeedsOnylXPars',
                        'Syntaxfehler: Die Funktion "%s" braucht nur %s Parameter',
                        [F.Bezeichnung, Inttostr(Length(F.Parameter))]), s)
                  end else If F.AllowStringPar then begin
                     If GetString (s, s2) then begin
                        Inc(Pars.AnzStr); Pars.Strs[Pars.AnzStr] := s2
                     end else Fehler(TrF('FunctionNeedStrPar',
                        'Syntaxfehler: Die Funktion "%s" braucht einen Stringparameter', [F.Bezeichnung]), s)
                  end else Fehler (TrF('FunctionNeedsPar', 'Syntaxfehler: Die Funktion "%s" braucht Parameter!',
                                   [F.Bezeichnung]), s)
               end
            end;
            Pars.Anz := Pars.AnzNum + Pars.AnzStr;
            Pars.Rest := s;
            Inhalt := F.Run (Pars);
            s := Pars.Rest;
            Original := false; Result := true; break
         end
      end
   end;
   If Original and (Not Fertig) then begin
      i := 2; p := 0;
      While (p=0) and (i<=Length(s)) do begin
         If s[i] = s[1] then p := i;
         Inc(i)
      end;
      Result := ((s+' ')[1] IN['"','''']) and (p>0);
      If Result then begin
         Inhalt := Copy(s,2,p-2);
         s := Trim(Copy(s,p+1,Length(s)-p))
      end
   end;
   If SucheUndKuerze('[', s) then begin
      ok := false;
      If GetNumber(s, x) then begin
         If SucheUndKuerze(']', s) then begin
            If (Trunc(x)<=Length(Inhalt)) and (Trunc(X)>0)
               then Inhalt := Inhalt[Trunc(x)]
               else Inhalt := '';
            ok := true;
         end
      end;
      If Not ok then Fehler (TrL('Use[x]toExtractSingleChar',
         'Syntaxfehler: Ein einzelnes Zeichen wird mit "String[Nummer]" extrahiert'), s)
   end;
   If Copy(Trim(s),1,1)='+' then begin
      s := Copy(s, Pos('+', s)+1, Length(s));
      While Copy(s,1,1)=' ' do s := Copy(s,2,Length(s)-1);
      Result := GetString (s, s2);
      If Result then Inhalt := Inhalt + s2
   end
end;

Function WordWrap (Const Org, Einrueckung: String; Const Breite: Integer): String;
Var i, j, zl, pSpace, p: Integer; Add: String; c: Char;
begin
   SetLength(Result, Length(Org)*2);
   zl := 0; p := 0; pSpace := 0; Add := '';
   For i := 1 to Length(Org) do begin
      c := Org[i];
      Case c of
         ' ': begin pSpace := i; Inc(zl) end;
         #13: begin zl := 0; pSpace := 0 end;
         #10: begin zl := 0; pSpace := 0; Add := c + Einrueckung end;
         else Inc(zl)
      end;
      If (zl > Breite) and (pSpace > 0) then begin
         If pSpace = i then begin
            If i < Length(Org) then Add := #13#10 + Einrueckung
         end else begin
            Add := #13#10 + Einrueckung + Copy(Org, pSpace+1, i-pSpace);
            Dec(p, i-pSpace)
         end;
         zl := 0; pSpace := 0
      end;
      If Length(Result)<p+Length(Add)+1 then SetLength(Result, p+Length(Add)+50);
      If Add > '' then begin
         For j := 1 to Length(Add) do begin
            Inc(p); Result[p] := Add[j]; Inc(zl)
         end;
         Add := ''
      end else begin
         Inc(p); Result[p] := c
      end
   end;
   SetLength(Result, p)
end;

Function TDummy.InternalFuncs (Var Pars: TStrParameter): String;
Var i: Integer; s: String; N1, N2, N3: Double; ok: boolean;
begin
   Result := '';
   With Pars do Case TSt(Typ) of
      stChr: If (Trunc(Nums[1])>0) and (Trunc(Nums[1])<255)
                then Result := Chr(Trunc(Nums[1]))
                else Fehler(TrF('FunctionChrAllowsOnlyValues1-255',
                     'Chr(x) ist nur mit 1-255 zulssig, nicht mit %s', [IntToStr(Trunc(Nums[1]))]), Rest);
      stLower: Result := AnsiLowerCase(Strs[1]);
      stUpper: Result := AnsiUpperCase(Strs[1]);
      stEscRegExp: Result := EscRegex(Strs[1]);
      stToIStr: Str(Nums[1]:0:0, Result);
      stToStr: begin
         N2 := 0; N3 := 0; i := 0;
         ok := Klammerung(Rest, s, true) and GetNumber(s, N1);
         If ok and (Trim(s)>'') then begin
            ok := SucheUndKuerze(',',s) and GetNumber(s, N2); Inc(i)
         end;
         If ok and (Trim(s)>'') then begin
            ok := SucheUndKuerze(',',s) and GetNumber(s, N3); Inc(i)
         end;
         If ok then begin
            s := '%';
            If (i>0) and (Trunc(N2)>0) then s := s + IntToStr(Trunc(N2));
            If (i>1) and (Trunc(N3)>=0) then s := s + '.' + IntToStr(Trunc(N3));
            s := s + 'g';
            Result := Format (s, [N1])
         end else Fehler(TrL('FunctionStrFalseUse',
             'Falsche Syntax, korrekt wre "Str(Zahl[,Zahl[,Zahl]])"'), Rest)
      end;
      stExtract: Result := ExtractRegExp (Strs[1], Strs[2]);
      stReplace: If Strs[2] > '' then Result := ReplaceString (Strs[1], Strs[2], Strs[3])
                                 else Result := Strs[1];
      stCutLeft: If Length(Strs[1]) > Nums[1]
                    then Result := Copy(Strs[1], Trunc(Nums[1])+1, Length(Strs[1])-Trunc(Nums[1]))
                    else Result := '';
      stCutRight: If Length(Strs[1]) > Nums[1]
                    then Result := Copy(Strs[1], 1, Length(Strs[1])-Trunc(Nums[1]))
                    else Result := '';
      stLeft: Result := Copy(Strs[1], 1, Trunc(Nums[1]));
      stRight: If Trunc(Nums[1])<Length(Strs[1])
                    then Result := Copy(Strs[1], Length(Strs[1])-Trunc(Nums[1])+1, Trunc(Nums[1]))
                    else Result := '';
      stCopy: Result := Copy(Strs[1], Trunc(Nums[1]), Trunc(Nums[2]));
      stFillChar: For i:=1 to Trunc(Nums[1]) do Result := Result + Strs[1];
      stWordWrap: Result := WordWrap (Strs[1], Strs[2], Trunc(Nums[1]));
      stTAB: Result := ^I;
      stCRLF: Result := #13#10;
      stLTrim: Result := LTrim(Strs[1]);
      stRTrim: Result := RTrim(Strs[1]);
      stTrim: Result := Trim(Strs[1]);
      stSigDel: Result := '-- ';
      stReadIni: With TIniFile.Create(Strs[1]) do try
                   Result := ReadString(Strs[2], Strs[3], Strs[4])
                 finally free end;
      stDateTime: Result := FormatDateTime5(Strs[1], Now);
      stDosToWin: begin
         SetLength(Result, Length(Strs[1])+1);
         OEMToChar(PChar(Strs[1]), @Result[1]);
         SetLength(Result, Length(Strs[1]))
      end;
      stWinToDos: begin
         SetLength(Result, Length(Strs[1])+1);
         CharToOEM(PChar(Strs[1]), @Result[1]);
         SetLength(Result, Length(Strs[1]))
      end;
   end
end;

Var Dummy: TDummy;

Procedure Init;
begin
   DecimalSeparator := '.';
   If Not Assigned(lFunctions) then With Dummy do begin
     lFunctions := TList.Create;
     Register_StrFunktion ('Chr', cNum, false, InternalFuncs, Ord(stChr));
     Register_StrFunktion ('Lower', cStr, false, InternalFuncs, Ord(stLower));
     Register_StrFunktion ('Upper', cStr, false, InternalFuncs, Ord(stUpper));
     Register_StrFunktion ('EscRegExp', cStr, false, InternalFuncs, Ord(stEscRegExp));
     Register_StrFunktion ('Str', cOwn, false, InternalFuncs, Ord(stToStr));
     Register_StrFunktion ('IStr', cNum, false, InternalFuncs, Ord(stToIStr));
     Register_StrFunktion ('Extract', cStr+cStr, false, InternalFuncs, Ord(stExtract));
     Register_StrFunktion ('Replace', cStr+cStr+cStr, false, InternalFuncs, Ord(stReplace));
     Register_StrFunktion ('CutLeft', cStr+cNum, false, InternalFuncs, Ord(stCutLeft));
     Register_StrFunktion ('CutRight', cStr+cNum, false, InternalFuncs, Ord(stCutRight));
     Register_StrFunktion ('Left', cStr+cNum, false, InternalFuncs, Ord(stLeft));
     Register_StrFunktion ('Right', cStr+cNum, false, InternalFuncs, Ord(stRight));
     Register_StrFunktion ('Copy', cStr+cNum+cNum, false, InternalFuncs, Ord(stCopy));
     Register_StrFunktion ('Trim', cStr, false, InternalFuncs, Ord(stTrim));
     Register_StrFunktion ('LTrim', cStr, false, InternalFuncs, Ord(stLTrim));
     Register_StrFunktion ('RTrim', cStr, false, InternalFuncs, Ord(stRTrim));
     Register_StrFunktion ('FillChar', cStr+cNum, false, InternalFuncs, Ord(stFillChar));
     Register_StrFunktion ('WordWrap', cStr+cNum+cStr, false, InternalFuncs, Ord(stWordWrap));
     Register_StrFunktion ('TAB', '', false, InternalFuncs, Ord(stTab));
     Register_StrFunktion ('CRLF', '', false, InternalFuncs, Ord(stCRLF));
     Register_StrFunktion ('CR', '', false, InternalFuncs, Ord(stCRLF));
     Register_StrFunktion ('Sigdelimiter', '', false, InternalFuncs, Ord(stSigDel));
     Register_StrFunktion ('ReadIni', cStr+cStr+cStr+cStr, false, InternalFuncs, Ord(stReadIni));
     Register_StrFunktion ('GetDateTime', cStr, false, InternalFuncs, Ord(stDateTime));
     Register_StrFunktion ('DosToWin', cStr, false, InternalFuncs, Ord(stDosToWin));
     Register_StrFunktion ('WinToDos', cStr, false, InternalFuncs, Ord(stWinToDos));
   end
end;

Procedure Register_StrFunktion (Const Bez: String; Const Par: String;
     Const AllowSingleStr: Boolean; Pr: TBoolStrFunc; Const AktTyp: Integer);
Var P: PFunctiondef;
begin
   Init;
   New (P);
   With P^ do begin
      Bezeichnung := Bez;
      Parameter := Par;
      Typ := AktTyp;
      AllowStringPar := AllowSingleStr;
      Run := Pr
   end;
   lFunctions.Add (P)
end;

Procedure Unregister_StrFunktion (Const Bez: String);
Var i: Integer;
begin
   With lFunctions do begin
      For i := Count-1 downto 0 do begin
         With PFunctiondef(Items[i])^ do begin
            If Bezeichnung = Bez then begin
               lFunctions.Delete(i); Exit
            end
         end
      end
   end
end;

Function ToStr(Const D: Double): String;
begin
   Result := FloatToStr(D);
end;
Function ToNum(Const s: String): Double;
begin
   Result := StrToFloat(s);
end;

Function RTrim(Const s: String): String;
Var i, l: Integer;
begin
   Result := s;
   l := 0;
   For i := Length(s) downto 1 do begin
      If (s[i]<>' ') and (s[i]<>^I) then begin
         l := i; break
      end
   end;
   If l <> Length(s) then SetLength(Result, l)
end;

Function LTrim(Const s: String): String;
Var i, p: Integer;
begin
   Result := s;
   p := 0;
   For i := 1 to Length(s) do begin
      If (s[i]<>' ') or (s[i]<>^I) then begin
         p := i-1; break
      end
   end;
   If p > 0 then Delete(Result, 1, p)
end;

// FormatDateTime

Function FormatDateTime5 (const Format: string; DateTime: TDateTime): String;
var
  BufPos, AppendLevel: Integer;
  Buffer: array[0..255] of Char;

  procedure AppendChars(P: PChar; Count: Integer);
  Var N: Integer;
  begin
    N := SizeOf(Buffer) - BufPos;
    if N > Count then N := Count;
    if N <> 0 then Move(P[0], Buffer[BufPos], N);
    Inc(BufPos, N);
  end;

  procedure AppendString(const S: string);
  begin
    AppendChars(Pointer(S), Length(S));
  end;

  procedure AppendNumber(Number, Digits: Integer);
  Const Format: array[0..3] of Char = '%.*d';
  Var NumBuf: array[0..15] of Char;
  begin
    AppendChars(NumBuf, FormatBuf(NumBuf, SizeOf(NumBuf), Format,
      SizeOf(Format), [Digits, Number]));
  end;

  procedure AppendFormat(Format: PChar);
  Var Starter, Token, LastToken: Char;
      Use12HourClock, BetweenQuotes: Boolean;
      P: PChar;
      Count: Integer;
      Year, Month, Day, Hour, Min, Sec, MSec, H: Word;

    procedure GetCount;
    Var P: PChar;
    begin
      P := Format;
      while Format^ = Starter do Inc(Format);
      Count := Format - P + 1;
    end;

    function ConvertEraString(const Count: Integer) : string;
    Var FormatStr: string; SystemTime: TSystemTime; Buffer: array[Byte] of Char;
    begin
      Result := '';
      with SystemTime do begin
        wYear  := Year; wMonth := Month; wDay   := Day;
      end;
      FormatStr := 'gg';
      if GetDateFormat(GetThreadLocale, DATE_USE_ALT_CALENDAR, @SystemTime,
         PChar(FormatStr), Buffer, SizeOf(Buffer)) <> 0
      then Result := Buffer
    end;

    function ConvertYearString(const Count: Integer): string;
    Var FormatStr: string; SystemTime: TSystemTime; Buffer: array[Byte] of Char;
    begin
      Result := '';
      with SystemTime do begin
        wYear  := Year; wMonth := Month; wDay   := Day;
      end;
      if Count <= 2
         then FormatStr := 'yy' // avoid Win95 bug.
         else FormatStr := 'yyyy';
      if GetDateFormat(GetThreadLocale, DATE_USE_ALT_CALENDAR, @SystemTime,
        PChar(FormatStr), Buffer, SizeOf(Buffer)) <> 0
      then begin
        Result := Buffer;
        if (Count = 1) and (Result[1] = '0') then Result := Copy(Result, 2, Length(Result)-1)
      end
    end;

  begin
    if (Format <> nil) and (AppendLevel < 2) then begin
      Inc(AppendLevel);
      LastToken := ' ';
      DecodeDate(DateTime, Year, Month, Day);
      DecodeTime(DateTime, Hour, Min, Sec, MSec);
      Use12HourClock := False;
      while Format^ <> #0 do begin
        Starter := Format^;
        Inc(Format);
        Token := Starter;
        if Token in ['a'..'z'] then Dec(Token, 32);
        if Token in ['A'..'Z'] then begin
          if (Token = 'M') and (LastToken = 'H') then Token := 'N';
          LastToken := Token
        end;
        case Token of
          'Y': begin
                 GetCount;
                 if Count <= 2
                    then AppendNumber(Year mod 100, 2)
                    else AppendNumber(Year, 4);
               end;
          'G': begin GetCount; AppendString(ConvertEraString(Count)) end;
          'E': begin GetCount; AppendString(ConvertYearString(Count)) end;
          'M': begin
                 GetCount;
                 case Count of
                   1, 2: AppendNumber(Month, Count);
                   3: AppendString(ShortMonthNames[Month]);
                   else AppendString(LongMonthNames[Month]);
                 end;
               end;
          'D': begin
                 GetCount;
                 case Count of
                   1, 2: AppendNumber(Day, Count);
                   3: AppendString(ShortDayNames[DayOfWeek(DateTime)]);
                   4: AppendString(LongDayNames[DayOfWeek(DateTime)]);
                   5: AppendFormat(Pointer(ShortDateFormat));
                   else AppendFormat(Pointer(LongDateFormat));
                 end;
               end;
          'H': begin
                 GetCount; BetweenQuotes := False; P := Format;
                 while P^ <> #0 do begin
                   case P^ of
                     'A', 'a': if not BetweenQuotes then begin
                         if ( (StrLIComp(P, 'AM/PM', 5) = 0)
                           or (StrLIComp(P, 'A/P',   3) = 0)
                           or (StrLIComp(P, 'AMPM',  4) = 0) )
                         then Use12HourClock := True;
                         Break;
                       end;
                     'H', 'h': Break;
                     '''', '"': BetweenQuotes := not BetweenQuotes;
                   end;
                   Inc(P);
                 end;
                 H := Hour;
                 if Use12HourClock then begin
                   if H = 0 then H := 12
                   else if H > 12 then Dec(H, 12)
                 end;
                 if Count > 2 then Count := 2;
                 AppendNumber(H, Count);
               end;
          'N': begin
                 GetCount;
                 if Count > 2 then Count := 2;
                 AppendNumber(Min, Count)
               end;
          'S': begin
                 GetCount;
                 if Count > 2 then Count := 2;
                 AppendNumber(Sec, Count);
               end;
          'T': begin
                 GetCount;
                 if Count = 1
                    then AppendFormat(Pointer(ShortTimeFormat))
                    else AppendFormat(Pointer(LongTimeFormat));
               end;
          'Z': begin
                 GetCount;
                 if Count > 3 then Count := 3;
                 AppendNumber(MSec, Count);
               end;
          'A': begin
                 P := Format - 1;
                 if StrLIComp(P, 'AM/PM', 5) = 0 then begin
                   if Hour >= 12 then Inc(P, 3);
                   AppendChars(P, 2);
                   Inc(Format, 4);
                   Use12HourClock := TRUE;
                 end else if StrLIComp(P, 'A/P', 3) = 0 then begin
                   if Hour >= 12 then Inc(P, 2);
                   AppendChars(P, 1);
                   Inc(Format, 2);
                   Use12HourClock := TRUE;
                 end else if StrLIComp(P, 'AMPM', 4) = 0 then begin
                   if Hour < 12 then
                     AppendString(TimeAMString) else
                     AppendString(TimePMString);
                   Inc(Format, 3);
                   Use12HourClock := TRUE;
                 end else if StrLIComp(P, 'AAAA', 4) = 0 then begin
                   AppendString(LongDayNames[DayOfWeek(DateTime)]);
                   Inc(Format, 3);
                 end else if StrLIComp(P, 'AAA', 3) = 0 then begin
                   AppendString(ShortDayNames[DayOfWeek(DateTime)]);
                   Inc(Format, 2);
                 end else begin
                   AppendChars(@Starter, 1);
                 end
               end;
          'C': begin
                 GetCount;
                 AppendFormat(Pointer(ShortDateFormat));
                 if (Hour <> 0) or (Min <> 0) or (Sec <> 0) then begin
                   AppendChars(' ', 1);
                   AppendFormat(Pointer(LongTimeFormat));
                 end;
               end;
          '/': AppendChars(@DateSeparator, 1);
          ':': AppendChars(@TimeSeparator, 1);
          '''', '"': begin
                 P := Format;
                 while (Format^ <> #0) and (Format^ <> Starter) do Inc(Format);
                 AppendChars(P, Format - P);
                 if Format^ <> #0 then Inc(Format);
               end;
           else AppendChars(@Starter, 1);
        end;
      end;
      Dec(AppendLevel);
    end;
  end;

begin
  BufPos := 0;
  AppendLevel := 0;
  if Format <> '' then AppendFormat(Pointer(Format)) else AppendFormat('C');
  SetString(Result, Buffer, BufPos);
end;

initialization
   Dummy := TDummy.Create;
   Init;
finalization
   With LFunctions do While Count > 0 do begin
      Dispose (PFunctiondef(Items[0])); Delete(0)
   end;
   lFunctions.free;
   Dummy.free
end.


