unit DAssiste;

interface

uses
  OleAuto, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Inifiles;

type
  TDlgAssistent = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  public
    Abschnitte: TStrings
  end;

implementation

Uses Settings;

{$R *.DFM}

procedure TDlgAssistent.Button3Click(Sender: TObject);
begin
   close
end;

procedure TDlgAssistent.Button1Click(Sender: TObject);
Var E: TKNEinstellungen; p: Integer; H: Variant; s: String;
begin
   If MessageDlg ('Folgende nderungen wrden durchgefhrt: falls noch nicht'
       +' vorhanden, werden die Abschnitte "news", "mails", "mails.in" und "mails.internal"'
       +' angelegt und mit den entsprechenden "Actions" im Hamster verknpft, so da z.B.'
       +' jede eingehende Mail mit dem "mails.in"-Abschnitt behandelt wird oder jedes'
       +' ausgehende Posting mit dem "news"-Abschnitt. Jeder Abschnitt bekommt eine eigene'
       +' "Header.def", bei "mails.in" und "mails.internal" sind alle Konvertierungen'
       +' defaultmig deaktiviert.' + #13#10#13#10 + 'nderungen durchfhren?',
       mtInformation, mbOkCancel, 0) = mrOk
   then begin
      try
         H := CreateOleObject('Hamster.App')
      except
         ShowMessage('Fehler: Hamsterobjekt nicht erzeugbar - Abbruch');
         exit
      end;
      s := H.ControlGetVersion;
      If s <= '1.3.21.0' then begin
         ShowMessage('Fehler: Zu alte Hamsterversion');
         exit
      end;

      p := Abschnitte.IndexOf('news');
      If p < 0 then begin
         E := TKNEinstellungen.Create; {p :=} Abschnitte.AddObject ('News', E);
         E.HeaderDef := 'News-out.def'
      end else begin
         E := TKNEinstellungen(Abschnitte.Objects[p])
      end;
      E.WorkPath := H.ControlGetNewsOutPath;

      p := Abschnitte.IndexOf('mails');
      If p < 0 then begin
         E := TKNEinstellungen.Create; {p :=} Abschnitte.AddObject ('Mails', E);
         E.HeaderDef := 'Mails-out.def'
      end else E := TKNEinstellungen(Abschnitte.Objects[p]);
      E.WorkPath := H.ControlGetMailsOutPath;

      If Abschnitte.IndexOf('mails.in')<0 then begin
         E := TKNEinstellungen.Create; E.NoActions;
         {p :=} Abschnitte.AddObject ('Mails.In', E);
         E.HeaderDef := 'Mails-in.def'
      end;
      If Abschnitte.IndexOf('mails.internal')<0 then begin
         E := TKNEinstellungen.Create; E.NoActions;
         E.WorkPath := H.ControlGetMailsPath + 'admin';
         {p :=} Abschnitte.AddObject ('Mails.Internal', E);
         E.HeaderDef := 'Mails-internal.def'
      end;
      s := H.ControlGetPath;
      If (s>'') and (s[length(s)]<>'\') then s := s + '\';
      With TIniFile.Create(s+'Hamster.ini') do try
         WriteString('Actions', 'news.out.exec', ExtractFilePath(ParamStr(0))+'Only_KN.exe');
         WriteString('Actions', 'news.out.pars', 'Type:news Filename:"%1"');
         WriteString('Actions', 'mail.out.exec', ExtractFilePath(ParamStr(0))+'Only_KN.exe');
         WriteString('Actions', 'mail.out.pars', 'Type:mails Filename:"%1"');
         WriteString('Actions', 'mail.in.exec', ExtractFilePath(ParamStr(0))+'Only_KN.exe');
         WriteString('Actions', 'mail.in.pars', 'Type:mails.in Filename:"%1"');
         WriteString('Actions', 'mail.internal.exec', ExtractFilePath(ParamStr(0))+'Only_KN.exe');
         WriteString('Actions', 'mail.internal.pars', 'Type:mails.internal Filename:"%1"');
      finally free end;
   end
end;

procedure TDlgAssistent.Button2Click(Sender: TObject);
Const Ausgehend: Array [1..3] of String  = ('mails', 'mail', 'news');
      KillHeader: Array [1..3] of String = ('X-Priority', 'X-MSMail-Priority', 'X-MimeOLE');
Var Anz, i, j, p: Integer; s: String;
begin
   If MessageDlg ('Folgende nderungen wrden fr die Abschnitte "News" und "Mail[s]" durchgefhrt: '
       +'Aktivierung der Optionen '
       +'"Optimierte ISO-Header", "OE-Kammquoting-Reparatur", "In Signatur-Trenner '
       +'wandeln" (auf "--"), "Leerzeilen am Ende lschen" und X-Header '
       +'"X-Priority", "X-MSMail-Priority" und "X-MimeOLE" lschen.'
       + #13#10#13#10 + 'nderungen durchfhren?',
       mtInformation, mbOkCancel, 0) = mrOk
   then begin
      Anz := 0;
      For i := Low(Ausgehend) to High(Ausgehend) do begin
         p := Abschnitte.IndexOf(Ausgehend[i]);
         If p >= 0 then With TKNEinstellungen(Abschnitte.Objects[p]) do begin
            Inc (Anz);
            CheckMIMEHeaders := true;
            DeleteEmptyLines := true;
            CheckOEZitate := true;
            If ConvertToSig = '' then ConvertToSig := '--';
            For j := Low(KillHeader) to High(KillHeader) do begin
               s := KillHeader[j];
               With LDelXHeader do
                  If (IndexOf(s)<0) and (IndexOf(s+':')<0) and (IndexOf(s+': ')<0)
                     then Add (s)
            end
         end
      end;
      If Anz = 0 then ShowMessage('Kein passender Abschnitt vorhanden!')
                 else ShowMessage(IntToStr(Anz)+' Abschnitte wie gewnscht eingestellt!')
   end
end;

end.
