unit uMIMEInf;

interface

uses uHeader;

Type
  TKodierung = (kNone, k7Bit, k8Bit, kQP, kBase64, kUnbekannt);
Var
  strKodierung: Array[TKodierung] of String =
     ('', '7bit', '8bit', 'quoted-printable', 'Base64', '');

Type
  TContentType = (ctUnbekannt, ctPlainText, ctHTML, ctUnknownText,
                  ctApplication, ctAudio, ctImage2, ctVideo);
Const
  IstText: Array[TContentType] of boolean =
                  (false, true, true, true, false, false, false, false);
  SaveAtt: Array[TContentType] of boolean =
                  (false, false, false, false, true, true, true, true);
  KodierungVariabel: Array[TContentType] of boolean =
                  (false, true, true, true, false, false, false, false);

Type
  TMIMEInfo = Record
     Exist, Multipart: boolean;
     Kodierung: TKodierung;
     Typ: TContentType;
     FileName: String;
     Charset: String;
     Trenner: String;
  end;

Function ExtractMimeInfo (Const MainHeader: boolean; Hd: THeader): TMimeInfo;
Procedure SetMimeCharset (Const MainHeader: boolean; Hd: THeader; Const CS: String);
Procedure SetMimeEncoding(Const MainHeader: Boolean; Hd: THeader; Const K: TKodierung);

implementation

Uses SysUtils;

Function ExtractMimeInfo (Const MainHeader: boolean; Hd: THeader): TMimeInfo;
Var Typ, Encoding, Disposition, s: String; p: Integer; K: TKodierung;
begin
   Result.Exist := (Not MainHeader) or (Hd.Inhalt ('MIME-Version', hiRaw) > '');

   If Not Result.exist then begin
      Typ := 'text/plain; charset=us-ascii';
      Encoding := '7-bit';
      Disposition := ''
   end else begin
      Typ := Hd.Inhalt ('Content-Type', hiRaw);
      Encoding := LowerCase(Hd.Inhalt ('Content-Transfer-Encoding', hiRaw));
      Disposition := Hd.Inhalt ('Content-Disposition', hiRaw)
   end;

   If Encoding = '' then begin
      Result.Kodierung := k7Bit
   end else begin
      Result.Kodierung := kUnbekannt;
      For k := Low(TKodierung) to High(TKodierung) do begin
         If strKodierung[k] > '' then begin
            If LowerCase(strKodierung[k]) = Encoding then begin
               Result.Kodierung := k; Break
            end
         end
      end
   end;

   s := LowerCase(Typ);
   If Trim(s) = '' then Result.Typ := ctPlainText
   else If Pos('text/plain', s) = 1 then Result.Typ := ctPlainText
   else If Pos('text/html', s) = 1 then Result.Typ := ctHTML
   else If Pos('text/', s) = 1 then Result.Typ := ctUnknownText
   else If Pos('application/', s) = 1 then Result.Typ := ctApplication
   else If Pos('audio/', s) = 1 then Result.Typ := ctAudio
   else If Pos('image/', s) = 1 then Result.Typ := ctImage2
   else If Pos('video/', s) = 1 then Result.Typ := ctVideo
   else Result.Typ := ctUnbekannt;

   Result.Trenner := '';
   p := Pos('boundary=', LowerCase(Typ));
   If p > 0 then begin
      p := p + Length('boundary=');
      s := Copy(Typ, p, Length(Typ));
      While (s > '') and (s[1] IN [#13,#10]) do Delete(s, 1, 1);
      If s > '' then begin
         If s[1] = '"' then begin
            Delete(s, 1, 1); p := Pos('"', s);
            If p > 0 then s := Copy(s, 1, p-1)
         end else begin
            p := Pos (' ', s);
            If p > 0 then s := Copy(s, 1, p-1)
         end;
         Result.Trenner := s
      end
   end;

   Result.Multipart := (Not MainHeader) or (Result.Trenner > '');

   Result.Charset := '';
   p := Pos('charset=', LowerCase(Typ));
   If p > 0 then begin
      p := p + Length('charset=');
      s := Copy(Typ, p, Length(Typ));
      If s > '' then begin
         If s[1] = '"' then begin
            Delete(s, 1, 1); p := Pos('"', s);
            If p > 0 then s := Copy(s, 1, p-1)
         end else begin
            p := Pos (' ', s);
            If p > 0 then s := Copy(s, 1, p-1)
         end;
         Result.Charset := LowerCase(s)
      end
   end;

   Result.Filename := '';
   p := Pos('filename=', LowerCase(Disposition));
   If p > 0 then begin
      p := p + Length('filename=');
      s := Copy(Disposition, p, Length(Disposition));
      If s > '' then begin
         If s[1] = '"' then begin
            Delete(s, 1, 1); p := Pos('"', s);
            If p > 0 then s := Copy(s, 1, p-1)
         end else begin
            p := Pos (' ', s);
            If p > 0 then s := Copy(s, 1, p-1)
         end;
         Result.FileName := LowerCase(s)
      end
   end

end;

Procedure SetMimeCharset (Const MainHeader: boolean; Hd: THeader; Const CS: String);
Var s, s2: String; p, p2: Integer;
begin
   if CS = '' then exit;
   If MainHeader then begin
      If Hd.Position ('MIME-Version') < 0 then Hd.Change('MIME-Version', '1.0')
   end;
   If Hd.Position ('Content-Type') < 0 then begin
      Hd.Change ('Content-Type', 'text/plain; charset='+CS);
      If Hd.Position ('Content-Transfer-Encoding') < 0
         then Hd.Change('Content-Transfer-Encoding', '8bit')
   end else begin
      s := Hd.Inhalt ('Content-Type', hiRaw);
      If s = '' then s := 'text/plain';
      p := Pos('charset=', LowerCase(s));
      If p = 0 then
         s := s + '; charset='+CS
      else begin
         p := p + Length('charset=');
         s2 := Copy(s, p, Length(s)-p+1);
         If s2 > '' then begin
            If s2[1] = '"' then begin
               Delete(s2, 1, 1);
               p2 := Pos('"', s2);
               If p2 > 0 then begin
                  p := p+1; p2 := p + p2 - 2
               end else begin
                  p2 := Length(s)
               end
            end else begin
               p2 := Pos(';', s2);
               If p2 > 0 then begin
                  p2 := p + p2 -1
               end else begin
                  p2 := Length(s)
               end
            end;
            Delete (s, p, p2-p+1);
            Insert (CS, s, p)
         end else begin
            s := s + CS
         end
      end;
      Hd.Change ('Content-Type', s)
   end;
   With ExtractMimeInfo (MainHeader, Hd) do begin
      If Exist and (Not Multipart) and (Charset='ascii') and (Typ = ctPlainText) then begin
         Hd.Change ('MIME-Version', '');
         Hd.Change ('Content-Type', '');
         Hd.Change ('Content-Transfer-Encoding', '');
      end
   end
end;

Procedure SetMimeEncoding(Const MainHeader: Boolean; Hd: THeader; Const K: TKodierung);
begin
   If K IN [kNone, kUnbekannt, k7Bit] then exit;
   If MainHeader then Hd.Change('MIME-Version', '1.0');
   Hd.Change('Content-Transfer-Encoding', StrKodierung[k]);
end;

end.
